function [h nr hs]=combofig(h,nxp,nyp,ip,xyranges,x,y,col,xlab,ylab,tit,redtick,xtlab,ytlab,sizefont)
%Plots in a combined figure with white background and minimises white
%spaces between plots. 
%If handle h is empty, a new figure is created. Use only when plotting multiple subplots with 
%identical x axis per column and y axis per row of subplots. 
%
%USAGE:
%[h nr hs]=combofig(h, nxp, nyp, ip, xyranges, x, y, col, xlab, ylab, tit ,redtick, xtlab, ytlab,sizefont)
%
%INPUT:
%nxp            : number of plots on x axis
%nyp            : number of y plots
%ip             : subplot number to plot in
%xyranges       : used to set the scale on axis, see help on axis
%col            : color and markers or lines used e.g. col='rd:', see help on plot
%               : when col is a cell array, it should contain:
%                 {symbol line style, line and/or edge color, and fill color}, e.g.
%                 {'d:' 'color' 'r' 'MarkerFaceColor' 'y'} for a red dotted line with filled yellow diamonds
%                 or {'d:' 'color' [0.3 0.3 0.3] 'MarkerFaceColor' [0.8 0.8 0.8]} for a dark grey
%                 line and light grey filled diamonds
%                 other line and color properties can be specified as well.
%xlab           : x label
%ylab           : y label
%tit            : text in subplot
%redtick [1/0]  : removes first tick on y axis. Use only once in a series of plottings
%xtlab [2/1/0]  : [2] show x tick labels on all subplots or only on
%                 bottom [1] or none [0]
%ytlab [2/1/0] : show y tick labels on all [2] subplots or only on
%                 left [1] or none [0]
%sizefont      : 10 is default.
%
%OUTPUT
%h              : figure handle
%nr             : line nr, use for adding legends. See help on legend
%hs             : legend box handle
%
%
%Tom Schut, 2007
if nargin < 15 sizefont=10; end
if nargin < 14 ytlab=1; end
if nargin < 13 xtlab=1; end
if nargin < 12 redtick=0; end
if nargin < 11 tit=[]; end
if nargin < 10 ylab=[]; end
if nargin <  9 xlab=[]; end
if nargin <  8 col='-k'; end
if nargin <  7 error('not enough input arguments'); end

if ip > (nxp * nyp) error('ip larger than nxp*nyp'); end


if ytlab==0 marginl=0.01; else marginl=0.05; end
marginr=0.01;
margint=0.01;
if xtlab==0 marginb=0.01; else marginb=0.06; end
if xtlab==0 | xtlab==1 marginy=0.015; else marginy=0.06;end
if ytlab==0 | ytlab==1 marginx=0.015; else marginx=0.06;end
psy=(1-(nyp-1)*marginy-margint-marginb)/nyp;
psx=(1-(nxp-1)*marginx-marginr-marginl)/nxp;

scrsz = get(0,'ScreenSize');
scrsz(3) = min(scrsz(3),1024); 
scrsz(4) = min(scrsz(4),1024);
figsize=[scrsz(1) 0.04*scrsz(4) scrsz(3) 0.88*scrsz(4)]; %allows small margin at top and bottom


if mod(ip,nxp)==0 ix=nxp; 
else ix=mod(ip,nxp); end
iy=1 + (ip - ix) / nxp;

if isempty(h)
    h=figure();
    set(h,'position',figsize);set(h,'Color',[1 1 1]);
else
    h=figure(h);
end

hs=subplot('position',[marginl+ (ix-1)*(marginx+psx),marginb+ (nyp-iy)*(marginy+psy), psx psy]);
set(hs,'FontSize',sizefont);

if iscell(col) 
    if length(col)==1      nr=plot(x, y, col{1});hold on;
    elseif length(col)==3  nr=plot(x, y, col{1}, col{2}, col{3});hold on;
    elseif length(col)==5  nr=plot(x, y, col{1}, col{2}, col{3}, col{4}, col{5});hold on;
    elseif length(col)==7  nr=plot(x, y, col{1}, col{2}, col{3}, col{4}, col{5},col{6}, col{7});hold on;
    elseif length(col)==9  nr=plot(x, y, col{1}, col{2}, col{3}, col{4}, col{5},col{6}, col{7},col{8},col{9});hold on;
    else 
        error('first line property for marker, then pairs for other properties. Max nr of pairs==9');
    end
else
    nr=plot(x, y, col);hold on;
end
%{
if iscell(col) 
    if length(col)==3
    nr=plot(x, y, col{1}, col{2}, col{3},'MarkerFaceColor',col{3});hold on;
elseif iscell(col) & length(col)==2
%    nr=plot(x, y, col{1}, 'Color', col{2}, 'LineWidth',3);hold on;
    nr=plot(x, y, col{1}, 'Color', col{2});hold on;
else
    nr=plot(x, y, col);hold on;
end
%}

if ~isempty(xyranges) 
    axis(xyranges); 
else
    xyranges=[min(x) max(x) min(y) max(y)];
end;
if ~isempty(tit) && ~isempty(xyranges) 
    text(1.05*double(xyranges(1)),0.95 * double(xyranges(4)),tit);
end

if ytlab==0 set(gca,'YTicklabel',[]);
elseif ix>1 & ytlab==1 set(gca,'YTicklabel',[]);
elseif  ~isempty(ylab) ylabel(ylab); hold on;
end

if xtlab==0 set(gca,'XTicklabel',[]);
elseif iy~=nyp & xtlab==1 set(gca,'XTicklabel',[]);
elseif ~isempty(xlab) xlabel(xlab); hold on;
end

if iy<nyp & redtick ticks=get(gca,'YTick');set(gca,'YTick',ticks(2:end)); end